/*
 * A UDP sender.
 * 
 * The webserver is optional and is used in this demo only for the user interface
 * 
 * After starting this webserver,
 * browse to this sender's IP address shown on the serial monitor.
 * Click on the buttons on the webpage to send a UDP message packet to the receiver.
 * The message contains a command to turn on and off the built-in led.
 * 
 * Copyright 2016 Enoch Hwang
 */

//#define ESP8266_01  // define this when using the ESP8266-01
//#define ESP32       // define this when using the ESP32
                      // defaults to using the ESP8266-12

//////////////////////////////////////////////////////////////
//// WiFi stuff
#define UDPreceiverPort 1080
#include <WiFi_RobotsForFun.h>
IPAddress UDPreceiverIP(192, 168, 1, 80);
char ssid[SSID_SIZE] = "your ssid";  // change to your ssid and password, or empty to load from EEPROM
char password[PASSWORD_SIZE] = "your password";


//////////////////////////////////////////////////////////////
//// UDP stuff
String waitForAck() {
  char packetBuffer[255]; //buffer to hold incoming udp packet
  int packetSize;
  unsigned long timeOut = millis() + 3000;
  while (true) {
    packetSize = receivePacket(packetBuffer); // get ack
    if (packetSize > 0) {
      return String(packetBuffer);
    }
    if (millis() > timeOut) {
      return "Time out. Did not get an ack";
    }
    delay(10);
  }
}


//////////////////////////////////////////////////////////////
//// HTML webpage 
void indexHTML() {
  String msg = "";
  String receivedMsg = "";
  
  // get url arguments and process the command
  // do it here to see the changes reflect in the current webpage
  // should not have long time delays otherwise the webpage will be very slow to load
  if (server.hasArg("LED")) {
    if (String(server.arg("LED")) == "OFF") {
      sendPacket("OFF", sizeof("OFF"), UDPreceiverIP, UDPreceiverPort);
      digitalWrite(statusLed, LEDOFF);  // turn off LED
      ledStatus = LEDOFF;
      Serial.println("turn off LED");
    } else if (String(server.arg("LED")) == "ON") {
      sendPacket("ON", sizeof("ON"), UDPreceiverIP, UDPreceiverPort);
      digitalWrite(statusLed, LEDON);   // turn on LED
      ledStatus = LEDON;
      Serial.println("turn on LED");
    } else if (String(server.arg("LED")) == "BLINK") {
      sendPacket("BLINK", sizeof("BLINK"), UDPreceiverIP, UDPreceiverPort);
      ledStatus = LEDBLINK;                // blink LED
      Serial.println("blink LED");
    }
    Serial.print("Waiting for acknowledge. ");
    receivedMsg = waitForAck();
  }

  msg += "<!DOCTYPE html>";
  msg += "<head>";
  msg += "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">"; // keep fonts consistent between devices
  
  msg += "<title>ESP8266 Demo</title>";
  msg += "  <style>";
  msg += "    body { background-color: #ffffff; font-family: Arial, Helvetica, Sans-Serif; Color: #000088; }";
  msg += "  </style>";
  msg += "</head>";
  
  msg += "<body>";
  msg += "<center><font size = \"3\"><b>UDP Sender</b></font><br>";
  msg += "This ESP8266 demo webserver allows you to send a UDP packet to the receiver to turn on and off its built-in LED.";
  msg += "</center>";
  msg += "<hr><br>";

  msg += "Start the receiver if not already started.";
//  msg += "<br>Browse to the receiver's IP address 192.168.1.80.";
  msg += "<br>Browse to the receiver's IP address at ";
  msg += UDPreceiverIP.toString();
  msg += "<hr><br>";

  msg += "Click a button below to send a UDP message to the receiver<br><br>";
  msg += "Current led status is ";
  switch(ledStatus) {
    case LEDOFF: 
      msg += "<b>OFF</b>"; 
      msg += "<br>Turn led&nbsp;";
      msg += "<a href=\"/\?LED=ON\"><button style=\"font-size:16pt\">ON</button></a>";
      break;
    case LEDON: 
      msg += "<b>ON</b>"; 
      msg += "<br>Turn led&nbsp;";
      msg += "<a href=\"/\?LED=BLINK\"><button style=\"font-size:16pt\">BLINK</button></a>";
      break;
    default: 
      msg += "<b>BLINK</b>"; 
      msg += "<br>Turn led&nbsp;";
      msg += "<a href=\"/\?LED=OFF\"><button style=\"font-size:16pt\">OFF</button></a>";
      break;
  }

  // another way to create the buttons
  msg += "<br><br>Another way to do it:";
  msg += "<form style=\"font-size:12pt\">";
  msg += "Click ";
  msg += "<input type=\"submit\" name=\"LED\" value=\"OFF\" style=\"font-size:16pt\" >";
  msg += "&nbsp;to turn off led";
  msg += "<br>Click ";
  msg += "<input type=\"submit\" name=\"LED\" value=\"ON\" style=\"font-size:16pt\" >";
  msg += "&nbsp;to turn on led";
  msg += "<br>Click ";
  msg += "<input type=\"submit\" name=\"LED\" value=\"BLINK\" style=\"font-size:16pt\" >";
  msg += "&nbsp;to blink led";
  msg += "</form>";

  msg += "<hr><br>";
  msg += "Acknowledge message received from RECEIVER ";
  msg += udp.remoteIP().toString();
  msg += ":";
  msg += udp.remotePort();
  msg += ": ";
  msg += receivedMsg;
  
  // wifi setup and info links
  msg += "<br><hr>IP address: ";
  if (wifiIsConnected) {
    msg += "<a href=\"/\">" + WiFi.localIP().toString() + "</a>";
    msg += "<br>Wifi setup and info: ";
    msg += "<a href=\"/setup\">" + WiFi.localIP().toString() + "/setup</a>";
  } else {
    msg += "<a href=\"http://1.2.3.4\">1.2.3.4</a>";
    msg += "<br>Wifi setup and info: ";
    msg += "<a href=\"http://1.2.3.4/setup\">1.2.3.4/setup</a>";
  }

  msg += "</body>";
  msg += "</html>";

  // send webpage to browser
  server.send(200, "text/html", msg);

  // get url arguments and process the command
  // changes here will not be reflected in the current webpage
  // can have long time delays since the webpage has already been sent back to the client

}


void setup() {
  Serial.begin(115200);
  pinMode(statusLed, OUTPUT);
  
  setupWiFi(ssid, password);
  
  Serial.println();
  Serial.println("This is the UDP SENDER");
  Serial.print("Browse to this sender's IP address at ");
  Serial.println(WiFi.localIP().toString());
  Serial.print("to send a UDP packet to the receiver at ");
  Serial.println(UDPreceiverIP.toString());
  Serial.println();
}

void loop() {
  
  flashActivityLed();     // show system is alive
  server.handleClient();  // handle web client request
}
