/*
 * A UDP receiver.
 *
 * The webserver is optional and is used in this demo only for the user interface
 * 
 * After starting this webserver,
 * browse to this receiver's static IP address 192.168.1.80
 * to see when the sender has sent a message packet.
 * The message contains a command to turn on and off the built-in led.
 * 
 * Copyright 2016 Enoch Hwang
 */

//#define ESP8266_01  // define this when using the ESP8266-01
//#define ESP32       // define this when using the ESP32
                      // defaults to using the ESP8266-12

//////////////////////////////////////////////////////////////
//// WiFi stuff
#define UDPreceiverPort 1080
#include <WiFi_RobotsForFun.h>
IPAddress staticIP(192, 168, 1, 80);
char ssid[SSID_SIZE] = "your ssid";  // change to your ssid and password, or empty to load from EEPROM
char password[PASSWORD_SIZE] = "your password";


//////////////////////////////////////////////////////////////
//// UDP stuff
String message = "";

void checkPacket() {
  static char packetBuffer[255]; //buffer to hold incoming udp packet
  static int packetSize;
  packetSize = receivePacket(packetBuffer);
  if (packetSize > 0) {
    // received a packet. act on it
    message = String(packetBuffer); 
    if (message == "ON") {
      digitalWrite(statusLed, LEDON);
      ledStatus = LEDON;
      Serial.println("turn on LED");
    } else if (message == "OFF") {
      digitalWrite(statusLed, LEDOFF);
      ledStatus = LEDOFF;
      Serial.println("turn off LED");
    } else if (message == "BLINK") {
      ledStatus = LEDBLINK;
      Serial.println("blink LED");
    }
    // optional send acknowledgement back to sender
    message.toCharArray(packetBuffer, 255);
    ackPacket(packetBuffer, message.length());  
  }
  
}


//////////////////////////////////////////////////////////////
//// HTML webpage 
void indexHTML() {
  String msg = "";
  String receivedMsg = "";
  
  // get url arguments and process the command
  // do it here to see the changes reflect in the webpage
  // should not have long time delays otherwise the webpage will be very slow to load

  msg += "<!DOCTYPE html>";
  msg += "<head>";
  msg += "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">"; // keep fonts consistent between devices
  msg += "<meta http-equiv=\"refresh\" content=\"1\">"; // auto refresh page every 1 second
  
  msg += "<title>ESP8266 Demo</title>";
  msg += "  <style>";
  msg += "    body { background-color: #ffffff; font-family: Arial, Helvetica, Sans-Serif; Color: #000088; }";
  msg += "  </style>";
  msg += "</head>";
  
  msg += "<body>";
  msg += "<center><font size = \"3\"><b>UDP Receiver</b></font><br>";
  msg += "This ESP8266 demo webserver waits for a UDP packet from the sender to turn on and off the built-in LED.";
  msg += "</center>";
  msg += "<hr><br>";

  msg += "Start the sender if not already started.";
  msg += "<br>Browse to the sender's IP address shown on its serial monitor.";
  msg += "<br>Click on the buttons on that webpage to send a UDP message packet to this receiver.";
  msg += "<br>This receiver has a static IP address " + WiFi.localIP().toString();
  msg += "<hr><br>";
  
  msg += "Message received from SENDER ";
  msg += udp.remoteIP().toString();
  msg += ":";
  msg += udp.remotePort();
  msg += ": ";
  msg += message;
  
  // wifi setup and info links
  msg += "<br><hr>IP address: ";
  if (wifiIsConnected) {
    msg += "<a href=\"/\">" + WiFi.localIP().toString() + "</a>";
    msg += "<br>Wifi setup and info: ";
    msg += "<a href=\"/setup\">" + WiFi.localIP().toString() + "/setup</a>";
  } else {
    msg += "<a href=\"http://1.2.3.4\">1.2.3.4</a>";
    msg += "<br>Wifi setup and info: ";
    msg += "<a href=\"http://1.2.3.4/setup\">1.2.3.4/setup</a>";
  }

  msg += "</body>";
  msg += "</html>";

  // send webpage to browser
  server.send( 200, "text/html", msg);

  // get url arguments and process the command
  // changes here will not be reflected in the current webpage
  // can have long time delays since the webpage has already been sent back to the client

}


void setup() {
  Serial.begin(115200);
  pinMode(statusLed, OUTPUT);
    
  setupWiFi(ssid, password, staticIP);

  Serial.println();
  Serial.println("This is the UDP RECEIVER");
  Serial.print("Browse to this receiver's static IP address ");
  Serial.println(WiFi.localIP().toString());
  Serial.println("for instructions and the user interface.");
  Serial.println();
  Serial.println("Waiting for UDP packets from the sender...");
  Serial.println();
}

void loop() {
  checkPacket();
  
  flashActivityLed();     // show system is alive
  server.handleClient();  // handle web client request
}
