/*
 * A webserver that allows you to control a stepper motor.
 * The webserver is implemented on the ESP8266-12 WiFi module. 
 *
 * Connect IN1 on the stepper motor controller board to pin D16 on the ESP8266
 * Connect IN2 on the stepper motor controller board to pin D14 on the ESP8266
 * Connect IN3 on the stepper motor controller board to pin D12 on the ESP8266
 * Connect IN4 on the stepper motor controller board to pin D13 on the ESP8266
 * Connect - on the stepper motor controller board to GND 
 * Connect + on the stepper motor controller board to +5V 
 *
 * After uploading this program to the ESP8266 module,
 * open the monitor and restart the ESP8266 module to 
 * see what IP address is assigned to this webserver,
 * then browse to this IP address.
 * 
 * Copyright 2016 Enoch Hwang
 */

#define statusPin 13
#include <WiFi_RobotsForFun.h>
char ssid[SSID_SIZE] = "your ssid";  // change to your ssid and password, or empty to load from EEPROM
char password[PASSWORD_SIZE] = "your password";

//////////////////////////////////////////////////////////////
//// Stepper motor stuff
#define IN1 16
#define IN2 14
#define IN3 12
#define IN4 13

void motor(int orange, int yellow, int pink, int blue) {
  // each call will rotate the motor one step
  digitalWrite(IN1, orange);
  digitalWrite(IN2, yellow);
  digitalWrite(IN3, pink);
  digitalWrite(IN4, blue);
  delay(2);
}

// turn s steps clockwise
void clockwise(int s) {
  for (int i=0; i<s; i++) {
    motor(1,1,0,0);
    motor(0,1,1,0);
    motor(0,0,1,1);
    motor(1,0,0,1);
  }
  delay(2);
  motor(0,0,0,0); // turn motor off
}

// turn s steps counterclockwise
void counterclockwise(int s) {
  for (int i=0; i<s; i++) {
    motor(1,0,0,1);
    motor(0,0,1,1);
    motor(0,1,1,0);
    motor(1,1,0,0);
  }
  delay(2);
  motor(0,0,0,0); // turn motor off
}

//////////////////////////////////////////////////////////////
//// Webserver stuff
void handleSTAClient() {
  String msg = "";
  msg += "<!DOCTYPE html>";
  msg += "<head>";
  msg += "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">"; // keep fonts consistent between devices
  
  msg += "<title>ESP8266 Demo</title>";
  msg += "  <style>";
  msg += "    body { background-color: #cccccc; font-family: Arial, Helvetica, Sans-Serif; Color: #000088; }";
  msg += "  </style>";
  msg += "</head>";
  
  msg += "<body>";
  msg += "  <h1>Hello from RobotsForFun!</h1>";
  msg += "  This is an ESP8266 demo webserver that allows you to control a stepper motor.";
  msg += "<br><br>";

  msg += "Select the direction and number of steps to rotate:<br><br>";
  
  // create inputs
  msg += "  <form>";
  msg += "  <input type=\"radio\" name=\"DIRECTION\" value=\"CLOCKWISE\" checked>";
  msg += " Clockwise<br>";
  msg += "  <input type=\"radio\" name=\"DIRECTION\" value=\"COUNTERCLOCKWISE\" >";
  msg += " Counter clockwise<br>";
  msg += " Steps: ";
  msg += "0 ";
  msg += "  <input type=\"range\" name=\"STEPS\" min=\"0\" max=\"1000\" value=\"0\">";
  msg += "1000";
  msg += "  <br><br>";
  msg += "  <input type=\"submit\">";
  msg += "  </form>";
      
  msg += "<br><br>";  
  msg += "Go to <a href=\"http://www.RobotsForFun.com\">RobotsForFun.com</a> for more interesting projects.";

  msg += "</body>";
  msg += "</html>";

  // send webpage to browser
  server.send ( 200, "text/html", msg);

  
  // get url arguments and process command
  if (server.args() == 2) { // make sure there are two arguments
    int steps=0;
    if (server.argName(1).equals("STEPS")) {  // make sure the argument name is correct
      Serial.print(server.arg(1));
      steps = server.arg(1).toInt();
    }
    if (server.argName(0).equals("DIRECTION")) {  // make sure the argument name is correct
      if (server.arg(0).equals("CLOCKWISE")) {
        Serial.println(" steps clockwise");
        clockwise(steps);
      } else {
        Serial.println(" steps counter clockwise");
        counterclockwise(steps);
      }
    }  
  }
}

void setup() {
  Serial.begin(115200);

  // set up the stepper motor
  pinMode(IN1, OUTPUT);
  pinMode(IN2, OUTPUT);
  pinMode(IN3, OUTPUT);
  pinMode(IN4, OUTPUT);
  clockwise(100);
  delay(300);
  counterclockwise(100);

  WiFiconnected = connectWiFi(ssid, password);  // connect to WiFi
}

void loop() {
  server.handleClient();
}
