/*
 * A webserver that allows you to control a servo motor.
 * The webserver is implemented on the ESP8266 WiFi module. 
 *
 * Connect the yellow wire on the servo to pin D12 on the ESP8266-12,
 * or pin D2 for the ESP8266-01.
 * Connect the brown wire to GND
 * Connect the red wire to +5V
 *
 * After uploading this program to the ESP8266 module,
 * open the monitor and restart the ESP8266 module to 
 * see what IP address is assigned to this webserver,
 * then browse to this IP address.
 * 
 * Copyright 2016 Enoch Hwang
 */

//////////////////////////////////////////////////////////////
//// status LED stuff
//#define ESP8266_01  // define this when using the ESP8266-01
#ifdef ESP8266_01
  #define statusLed 1     // for ESP8266-01
#else
  #define statusLed 2     // for ESP8266-12
#endif


//////////////////////////////////////////////////////////////
//// WiFi stuff
#include "WiFi_RobotsForFun.h"


//////////////////////////////////////////////////////////////
//// servo motor stuff
#ifdef ESP8266_01
  #define servoPin 2     // for ESP8266-01
#else
  #define servoPin 12    // for ESP8266-12
#endif
#include <Servo.h>
Servo myservo;
int pos;  // position of the servo, 0 - 180

//////////////////////////////////////////////////////////////
//// HTML webpage 
void indexHTML() {
  String msg = "";
  msg += "<!DOCTYPE html>";
  msg += "<head>";
  msg += "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">"; // keep fonts consistent between devices
  
  msg += "<title>ESP8266 Demo</title>";
  msg += "  <style>";
  msg += "    body { background-color: #cccccc; font-family: Arial, Helvetica, Sans-Serif; Color: #000088; }";
  msg += "  </style>";
  msg += "</head>";
  
  msg += "<body>";
  msg += "  <h1>Hello from RobotsForFun!</h1>";
  msg += "  This is an ESP8266 demo webserver that allows you to control a servo motor.";
  msg += "<br><br>";

  // get url arguments
  if (server.args() == 1) { // make sure there's one argument
    if (server.argName(0).equals("pos")) {  // make sure the argument name is "pos"
      pos = server.arg(0).toInt();          // get the value for this argument
    } else {
      pos = 0;
    }  
  }

  msg += "Servo is set at ";
  msg += String(pos);
  msg += " degrees.<br>";
  
  msg += "  <form>";
  
  // create a slider object
  msg += "  <input type=\"range\" name=\"pos\" min=\"0\" max=\"180\" value=\"";
  msg +=    String(pos);  // default value for the slider
  msg += "\" style=\"height:100px;width:200px\">";
  
  msg += "    <input type=\"submit\">";
  msg += "  </form>";

  msg += "<br><br><hr>";  
  msg += "Go to <a href=\"http://www.RobotsForFun.com\">RobotsForFun.com</a> for more interesting projects.";

  msg += "</body>";
  msg += "</html>";

  // send webpage to browser
  server.send(200, "text/html", msg);

  // turn servo to pos position
  myservo.write(pos);
}

void setup() {
  Serial.begin(115200);

  myservo.attach(servoPin);  // attaches the servo

  setupWiFi(); // use DHCP, ssid and password from EEPROM, default device name, and default blocking if cannot connect to wifi
}

void loop() {
  server.handleClient();
}
