//////////////////////////////////////////////////////////////
// Push Notification and Email PHP stuff
// PHP file on RobotsForFun.com
// For Push Notification: robotsforfun.com/iot/push_notification.php
// For EMail: robotsforfun.com/iot/email.php
//
const char* host = "robotsforfun.com";
const int httpPort = 80;
WiFiClient PHPserver;

boolean connectPHPServer() {
  // connect to PHP server
  if (!PHPserver.connect(host, httpPort)) {
    Serial.print("Cannot connect to PHP server ");
    Serial.println(host);
    PHPserver.stop();
    return false;
  } else {
    Serial.print("Connected to PHP server ");
    Serial.println(host);
    return true;
  }
}

// Send the POST data to the PHP server using POST
String sendURLPOST(String phpFile, String postData) {  
  if (!connectPHPServer()) {
    return "";
  }
  // Send the POST data to the PHP server using POST
  PHPserver.println("POST " + phpFile + " HTTP/1.1");
  PHPserver.println("Host: " + String(host));
  PHPserver.println("Connection: close");
  PHPserver.println("Content-Type: application/x-www-form-urlencoded");
  PHPserver.println("Content-Length: " + String(postData.length()));
  PHPserver.println();  // must have this extra blank line
  PHPserver.println(postData);
  
  int timeout = millis() + 5000;
  while (PHPserver.available() == 0) {
    if (timeout - millis() < 0) {
      Serial.println(">>> Server Timeout !");
      PHPserver.stop();
      return "";
    }
  }

  // Read all the lines of the reply from server and print them to Serial
  String line = "";
  while(PHPserver.available()){
    line += PHPserver.readStringUntil('\r');
  }
  //Serial.print("Received reply from PHP server=");
  //Serial.println(line);
  // optional trim off unwanted stuff from the line before printing out
  line = line.substring(line.indexOf("<br>"));
  line.remove(line.length()-4); // remove last unwanted 4 characters from line
  
  //Serial.println("closing connection");
  PHPserver.stop();
  return line;
}

//////////////////////////////////////////////////////////////
// Push Notification and PHP stuff
// PHP file on RobotsForFun.com
// robotsforfun.com/iot/push_notification.php
// see this file for more info
//
// Firebase project name: FirebaseIOT
// Android package name: com.mygadgets2.iotAlarm
// https://console.firebase.google.com/u/0/project/fir-iot-3829c/overview
//
// Usage:
//     sendPushNotification("title", "message");
String sendPushNotification(String title, String message) {
  String data = "";
  data += "title=";
  data += title;
  data += "&message=";
  data += message;
  // cannot have spaces if used in the URL so need to make this change for all spaces. Otherwise will get a 400 Bad request response from server
  data.replace(" ", "%20");

  // send notification using POST
  const String phpFile = "/iot/push_notification.php"; // the PHP file to execute
  String reply = sendURLPOST(phpFile, data);
  
  //Serial.println("Reply from PHP server:");
  //Serial.println(reply);
  return reply;  
}

//////////////////////////////////////////////////////////////
// EMail and PHP stuff
// PHP file on RobotsForFun.com
// robotsforfun.com/iot/email.php
// see this file for more info
//
// Usage:
//     sendEmail("enochhwangphd@gmail.com", "Driveway Alarm", "A person came in", "Home Alarm <alarm@robotsforfun.com>");
// or to send SMS text message to a phone number
//     sendEmail("9519072962@wireless.bellsouth.com", "Driveway Alarm", "A person came in", "Home Alarm <alarm@robotsforfun.com>"); // SMS text message to phone number
//     the domain must match your phone carrier
//        Verizon    @vtext.com
//        T-Mobile  @tmomail.net
//        ATT     @txt.att.net
//        Cricket   @wireless.bellsouth.com
//        Bellsouth @wireless.bellsouth.com
//     go to https://www.freecarrierlookup.com/
//     to find the carrier domain for a given phone number
String sendEmail(String address, String subject, String message, String from) {
  String data = "";
  data += "address="+address;
  data += "&subject="+subject;
  data += "&message="+message;
  data += "&from="+from;
  // cannot have spaces if used in the URL so need to make this change for all spaces. Otherwise will get a 400 Bad request response from server
  data.replace(" ", "%20");

  // send notification using POST
  const String phpFile = "/iot/email.php"; // the PHP file to execute
  String reply = sendURLPOST(phpFile, data);
  return reply;
}
