/*
 * Analog style clock using RGB LED ring
 * 
 * An access point (AP) and station (STA) webserver
 * that shows the time using NTP time on a 24-bit RGB WS2812 led ring
 * The webserver is implemented on the ESP8266-12 WiFi module. 
 * 
 * Connection:
 * DI pin on a 24-bit RGB WS2812 led ring to D2 on the ESP8266.
 * 
 * After uploading this program to the ESP8266 module,
 * open the monitor and restart the ESP8266 module to 
 * see what IP address is assigned to this webserver,
 * then browse to this IP address.
 * 
 * Copyright 2017 Enoch Hwang
 */
 
#define HANDLECONFIGCLIENT  // use the function in the library
#include <WiFi_RobotsForFun.h>
char ssid[SSID_SIZE] = "your ssid";  // change to your ssid and password, or empty to load from EEPROM
char password[PASSWORD_SIZE] = "your password";
char APssid[SSID_SIZE] = "Analog Clock AP";
char APpassword[PASSWORD_SIZE] = "";  // empty string for no password
char devicename[] = "RGBRingWebClock";   // change to what you want. Use "ping ESP8266" to test

//////////////////////////////////////////////////////////////
//// NTP clock stuff
#include <DateTime_RobotsForFun.h>


//////////////////////////////////////////////////////////
//// Analog style clock using RGB LED ring
#include <WS2812.h>
#define DI_PIN 2     // Digital pin that the DI signal is connected to
#define LED_COUNT 24  // Number of leds in the ring or strip
WS2812 leds = WS2812(LED_COUNT, DI_PIN, NEO_GRB + NEO_KHZ800);

void displayClock() {

  int h = hour12();
  int m = minute();
  int s = second();

  static boolean flip = true;
  if (s == 0) flip = !flip;

  if (s < 30) {
    s = map(s, 0, 25, 12, 22);
  } else {
    s = map(s, 30, 55, 0, 10);
  }
  if (flip) {
    leds.setPixelColor(s, 0, 20, 2);  // Set just one LED
  } else {
    leds.setPixelColor(s, 20, 6, 10);  // Set just one LED    
  }
  
  if (m < 30) {
    m = map(m, 0, 25, 12, 22);
  } else {
    m = map(m, 30, 55, 0, 10);
  }
  int m1 = m-1;
  int m2 = m-2;
  int m3 = m-3;
  if (m1 < 0) m1 = 24+m1;
  if (m2 < 0) m2 = 24+m2;
  if (m3 < 0) m3 = 24+m3;
  leds.setPixelColor(m, 0, 0, 255);  // Set just one LED
  leds.setPixelColor(m1, 0, 0, 100);  // Set just one LED
  leds.setPixelColor(m2, 0, 0, 47);  // Set just one LED
  leds.setPixelColor(m3, 0, 0, 8);  // Set just one LED

  if (h < 6) {
    h = h*2+12;
  } else {
    h = (h-6)*2;
  }
  int h1 = h-1;
  if (h1 < 0) h1 = 24+h1;
  leds.setPixelColor(h, 255, 0, 0);  // Set just one LED
  leds.setPixelColor(h1, 20, 0, 0);  // Set just one LED
  
  leds.show();   // ...but the leds don't actually update until you call this.

  // blink the second-hand LED
  delay(700);
  leds.setPixelColor(s, 0, 0, 0);  // Set just one LED
  leds.show();   // ...but the leds don't actually update until you call this.
  delay(300);
  if (flip) {
    leds.setPixelColor(s, 0, 20, 2);  // Set just one LED
  } else {
    leds.setPixelColor(s, 20, 6, 10);  // Set just one LED    
  }

}



//////////////////////////////////////////////////////////////
//// Webserver stuff
void handleSTAClient() {
  String msg = "";
  msg += "<!DOCTYPE html>";
  msg += "<head>";
  msg += "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">"; // keep fonts consistent between devices
  
  msg += "<title>ESP8266 Demo</title>";
  msg += "  <style>";
  msg += "    body { background-color: #cccccc; font-family: Arial, Helvetica, Sans-Serif; Color: #000088; }";
  msg += "  </style>";
  msg += "</head>";
  
  msg += "<body>";
  msg += "  <h1>Hello from RobotsForFun!</h1>";
  msg += "  This is an ESP8266 demo webserver that displays the time on a 24-bit RGB WS2812 led ring.";
  msg += "<br><br>";

  msg += formattedTime();

  msg += "<br><br><hr>";  
  msg += "Go to <a href=\"http://www.RobotsForFun.com\">RobotsForFun.com</a> for more interesting projects.";

  msg += "</body>";
  msg += "</html>";

  // send webpage to browser
  server.send ( 200, "text/html", msg);

}

void setupWiFi() {
  //const int channel = 1; // default
  //const int hidden = 1;  // 1=hide the ssid
  //setupAP(APssid, APpassword, channel, hidden); // to hide the SSID
  setupAP(APssid, APpassword);  // setup access point for 1.2.3.4
  setupConfigAP();              // setup config access point for 1.2.3.4:81
  for (int i=0; i<3; i++) { // try to connect 3 times
    //WiFiconnected = connectWiFi(ssid, password);  // connect to WiFi using DHCP
    WiFiconnected = connectWiFi(ssid, password, devicename);  // connect to WiFi using DHCP
    //WiFiconnected = connectWiFi(ssid, password, devicename, deviceIP, serverGateway);  // connect to WiFi using static IP
    if (WiFiconnected) {
      break;
    }
    Serial.print(i+1);
    Serial.println(" of 3 times");
    if (i < 2) delay(2000);
  }
  if (!WiFiconnected) {
    Serial.println("No internet connection.");
    Serial.print("Connect your WiFi to [");
    Serial.print(APssid);
    Serial.print("] using password [");
    Serial.print(APpassword);
    Serial.println("]");
    Serial.println("and then Browse to 1.2.3.4:81 to setup");
    while(true) {
      server.handleClient();
      configserver.handleClient();
      yield();
    }
  }
}

void setup() {
  Serial.begin(115200);
  leds.begin();      // Call this to start up the LED strip.
  leds.clear();   // turns all leds off...
  leds.setBrightness(255);  // 0=off; 255=full bright

  setupWiFi();
  setClock(PST);
}

void loop() {
  static time_t prevDisplay;
  syncClock(); // need to call this frequently to sync the clock
  if (now() != prevDisplay) { //update the display only if time has changed
    prevDisplay = now();
    displayClock();
    Serial.println(formattedTime());
  }

  server.handleClient();
  configserver.handleClient();
  yield();
}
