// Minimal example for WiFi NTP clock time
//
// Reference for struct tm as defined in <time.h>
// http://www.cplusplus.com/reference/ctime/
// http://www.cplusplus.com/reference/ctime/tm/
//
// Reference for configTime
// https://github.com/esp8266/Arduino/blob/9913e5210779d2f3c4197760d6813270dbba6232/cores/esp8266/time.c
// https://github.com/esp8266/Arduino/blob/61cd8d83859524db0066a647de3de3f6a0039bb2/libraries/esp8266/examples/NTP-TZ-DST/NTP-TZ-DST.ino
//
// only works with ESP8266 v2.4.0 or higher
// select from the menu Tools | Boards | Board Manager
// then install the ESP8266 v2.4.0 or higher
//
// Copyright (c) 2020 Enoch Hwang

#include <ESP8266WiFi.h>
#include <time.h>

char ssid[] = "your ssid";
char password[] = "your password";

void printTime() {
  static String wd[] = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
  time_t now = time(nullptr);
  struct tm *ptm;
  //ptm = gmtime(&now);  // convert time_t to tm structure as UTC time
  ptm = localtime(&now); // convert time_t to tm structure as local time
  Serial.print(wd[ptm->tm_wday]);
  Serial.print(" ");
  Serial.print(ptm->tm_year+1900);
  Serial.print("/");
  Serial.print(ptm->tm_mon+1);
  Serial.print("/");
  Serial.print(ptm->tm_mday);
  Serial.print(" ");
  Serial.print(ptm->tm_hour);
  Serial.print(":");
  Serial.print(ptm->tm_min);
  Serial.print(":");
  Serial.println(ptm->tm_sec);  
}

void setup() {
  Serial.begin(115200);
  Serial.println();
  
  //// set clock time zone to PST with automatic hourly updates and daylight savings time adjustments
  configTzTime("PST+8PDT,M3.2.0/2:00:00,M11.1.0/2:00:00", "0.pool.ntp.org");
  
  // connect to wifi
  WiFi.begin(ssid, password);
  Serial.print("Connecting to ");
  Serial.print(ssid);
  while (WiFi.status() != WL_CONNECTED) {
    Serial.print(".");
    delay(150);
  }
  Serial.println("connected");
  Serial.print("IP address is ");
  Serial.println(WiFi.localIP());
  
 Serial.println("Waiting for clock to sync with server");
  while (time(nullptr) < 30000) {
    Serial.print(".");
    yield();
    delay(500);
  }

  Serial.print("Clock set to ");
  time_t now = time(nullptr);
  Serial.println(ctime(&now));
}

void loop() {
  printTime();
  delay(1000);
}
