/*
 * Copy the Music_Shield_V2_0 to the Arduino libraries folder
 * Compiles using Arduino v1.0.5

 * This Music_Shield_V2_0 library is different from the original downloaded library
 * with added functions of my own

 * Can use any microSD card
 * Must use MP3 files

 * playWithName.ino
 * Example sketch for MusicShield 2.0
 *
 * Copyright (c) 2012 seeed technology inc.
 * Website    : www.seeed.cc
 * Author     : Jack Shao (jacky.shaoxg@gmail.com)
 * Create Time: Mar 2014
 * Change Log :
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


#include <SD.h>
#include <SPI.h>
#include <arduino.h>
#include <MusicPlayer.h>

void setup(void) {
  Serial.begin(9600);
  player.begin();                      //will initialize the hardware and set default mode to be normal.
  player.setVolume(0);  // 0 is loudest
  //player.setPlayMode(PM_REPEAT_ONE); //set mode to repeat playing a song
  player.setPlayMode(PM_PLAY_ONE);     //set mode to play a song once
  
  // play using the song name
  player.playOne("Starwars.mp3");          //play a song using its name

  // play using the song index number
  //player.scanAndPlayAll(); // add all songs on SD card to playlist
  //Serial.print("Number of songs: ");
  //Serial.println(player.opTotalSong());
  //player.playOne(0);       // play a song using index number 0

  //player.opStop();
}
void loop(void) {
  player.play();  //do some leisurely job
}
