/*
 * This is the Music Player and Software Serial Command Receiver
 * It waits for a command over the Software Serial line
 * When it receives a command, it will execute the command which
 * controls the Music Player.
 * The commands and format are:
 *  p# = play song at index #, e.g. p2 to play song at index 2
 *  v# = volume adjust to #,   e.g. v0 to set volume to 0 (loudest)

 * Copy the Music_Shield_V2_0 to the Arduino libraries folder
 * Compiles using Arduino v1.0.5

 * This Music_Shield_V2_0 library is different from the original downloaded library
 * with added functions of my own

 * Can use any microSD card
 * Must use MP3 files
 */


//////////////////////////////////////////////////////////////
//// Music player stuff
#include <SD.h>
#include <SPI.h>
#include <arduino.h>
#include <MusicPlayer.h>

//////////////////////////////////////////////////////////////
//// Software serial communication stuff
// RX is digital pin A4 (connect to TX of other device)
// TX is digital pin A5 (connect to RX of other device)
#include <SoftwareSerial.h>
SoftwareSerial mySerial(A4, A5); // RX, TX
char command;  // p=play; v=volume; s=stop;
int songIndex = 0;


void setup(void) {
  Serial.begin(115200);  
  mySerial.begin(38400); // set the data rate for the SoftwareSerial port

//// Music player stuff
  player.begin();                      //will initialize the hardware and set default mode to be normal.
  player.setVolume(0);  // 0 is loudest to about 50
  //player.setPlayMode(PM_REPEAT_ONE); //set mode to repeat playing a song
  player.setPlayMode(PM_PLAY_ONE);     //set mode to play a song once
  player.scanAndPlayAll(); // add all songs on SD card to playlist
  Serial.print("Number of songs: ");
  Serial.println(player.opTotalSong());

  player.playOne("out.mp3");          //play a song using its name
  player.play();  //do some leisurely job
  //player.opStop();
  
  // play using the song name
  //player.playOne("Starwars.mp3");          //play a song using its name

  // play using the song index number
  //player.scanAndPlayAll(); // add all songs on SD card to playlist
  //Serial.print("Number of songs: ");
  //Serial.println(player.opTotalSong());
  //player.playOne(2);       // play a song using index number 0

}
void loop(void) {
  //player.play();  //do some leisurely job
  
  // get command from Serial
  if (mySerial.available()) {
    command = mySerial.read();
    if (command == 'p') {
      songIndex = mySerial.parseInt();  // reads serial stream until a none int character
      Serial.print("Play song ");
      Serial.println(songIndex);
      if (songIndex >= 0 && songIndex < player.opTotalSong()) {
        player.playOne(songIndex);       // play song at index number
        Serial.println("Song started");
        player.playBlocking();  //do some leisurely job
        Serial.println("Song is finished");
      }
    } else if (command == 'v') {
      int volume = mySerial.parseInt();  // reads serial stream until a none int character
      Serial.print("Set volume to ");
      Serial.println(volume);
      if (volume >=0 && volume < 50) {
        player.setVolume(volume);  // 0 is loudest
      }
    } 
  }
  
//  if (player.songDone()) {
//    Serial.println("Song is finished");
//  }

}
