/*
Copy the Music_Shield_V2_0 to the Arduino libraries folder
Compiles using Arduino v1.0.5

This Music_Shield_V2_0 library is different from the original downloaded library
with added functions of my own

Can use any microSD card
*/

#include <SD.h>
#include <SPI.h>
#include <arduino.h>
#include <MusicPlayer.h>

#define beamSensor A4
#define motionSensor A5
boolean beamStatus, motionStatus;
int currentSong = 0;
unsigned long alarmOn;
int ledcount = 2;
boolean ledflagOn;

void setup(void) {
  Serial.begin(9600);
  pinMode(beamSensor, INPUT_PULLUP);
  pinMode(motionSensor, INPUT_PULLUP);
  alarmOn = 0;
  
  player.begin();
  player.setVolume(0);  // 0 is loudest
  player.setPlayMode(PM_PLAY_ONE);
  player.scanAndPlayAll(); // add all songs on SD card to playlist
}

void loop() {
  while(1) {
  player.play();  // main play FSM routine

  // alarm has been triggered; delay before resetting
  if (alarmOn > 0) {
    if (millis() < alarmOn) {
      GREEN_LED_OFF();
      RED_LED_ON();
      continue;  // this will skip checking the sensors
    } else {
      alarmOn = 0;
      GREEN_LED_OFF();
      RED_LED_OFF();
    }
  }
  
  beamStatus = digitalRead(beamSensor);
  motionStatus = digitalRead(motionSensor);

  // check for coming in
  if((beamStatus == LOW) && (motionStatus == HIGH)) {
    GREEN_LED_ON();
    RED_LED_ON();
    ledcount = 5;
    for(int i=0; i<70; i++) {
      // wait for motion sensor trigger
      if(digitalRead(motionSensor) == LOW) {
        RED_LED_ON();
        // motion sensor triggered
        Serial.println();
        Serial.println("Motion sensor triggered");
        //player.opNextSong();
        //player.opPlay();
        if (currentSong == player.opTotalSong()-1) currentSong = 0;
        else currentSong++;
        alarmOn = millis()+2000;  // time to reset
        player.playOne(currentSong);
        break;
      }
      // show some activities      
      Serial.print(";");
      ledcount--;
      if (ledcount == 0) {
        ledcount = 5;
        if (ledflagOn) {
          //GREEN_LED_ON();
          RED_LED_OFF();
          ledflagOn = 0;
        } else {
          //GREEN_LED_OFF();
          RED_LED_ON();
          ledflagOn = 1;
        }
      }
      delay(100);
    } // for
    
  // check for going out
  } else if((beamStatus == HIGH) && (motionStatus == LOW)) {
    GREEN_LED_ON();
    RED_LED_ON();
    ledcount = 5;
    for(int i=0; i<70; i++) {
      // wait for beam sensor trigger      
      if(digitalRead(beamSensor) == LOW) {
        RED_LED_ON();
        // beam sensor triggered
        Serial.println();
        Serial.println("Beam sensor triggered");
        currentSong = player.opCurrentSong();
        player.playOne("OUT.MP3");
        alarmOn = millis()+2000;  // time to reset
        break;
      }
      // show some activities      
      Serial.print(".");
      ledcount--;
      if (ledcount == 0) {
        ledcount = 5;
        if (ledflagOn) {
          //GREEN_LED_OFF();
          RED_LED_ON();
          ledflagOn = 0;
        } else {
          //GREEN_LED_ON();
          RED_LED_OFF();
          ledflagOn = 1;
        }
      }
      delay(100);
    } // for
  }
  
  // show some activities      
  RED_LED_OFF();
  ledcount--;
  if (ledcount == 0) {
    ledcount = 8;
    GREEN_LED_ON();
    delay(80);
    GREEN_LED_OFF();
    delay(140);
    GREEN_LED_ON();
    delay(80);
    GREEN_LED_OFF();
  } else {
    delay(300);
  }
  Serial.print("*");

  } // while(1)
}



