#include "LedControl.h"
 
// MAX72XX connections
int DIN = 12;
int CS = 11;
int CLK = 10;
int NO = 1;  // number of MAX72XX devices connected

LedControl lc = LedControl(DIN, CLK, CS, NO);

/////////////////////////////////////////////////////////////
int thousand, hundred, ten, unit;
// extract the individual digits from the given number
void extract(int number) {
  thousand = number/1000;
  number = number - thousand*1000;
  hundred = number/100;
  number = number - hundred*100;
  ten = number/10;
  unit = number - ten*10;
}

void displayNumber(int number) {
  extract(number);
  lc.setDigit(0,3,thousand,false);
  lc.setDigit(0,2,hundred,false);
  lc.setDigit(0,1,ten,false);
  lc.setDigit(0,0,unit,false);
}

void setup() {
  // the first parameter is the address of the MAX72XX chip in the daisy chain
  lc.shutdown(0, false);  // The MAX72XX is in power-saving mode on startup
  lc.clearDisplay(0);
  lc.setIntensity(0, 15);  // set the brightness 15=max

  // the parameters are
  // (MAX72XX device 0, digit number, value to display, decimal point on)
  // right-most digit is D0
  lc.setDigit(0,0,0,false);
  lc.setDigit(0,1,1,false);
  lc.setDigit(0,2,2,false);
  lc.setDigit(0,3,3,false);
  lc.setDigit(0,4,4,false);
  lc.setDigit(0,5,5,false);
  lc.setDigit(0,6,6,false);
  lc.setDigit(0,7,7,false);
  delay(2000);
  
  lc.setChar(0,0,'-',false);
  lc.setChar(0,1,'-',false);
  lc.setChar(0,2,'-',false);
  lc.setChar(0,3,'O',false);
  lc.setChar(0,4,'L',false);
  lc.setChar(0,5,'L',false);
  lc.setChar(0,6,'E',false);
  lc.setChar(0,7,'H',false);
  delay(2000);
  lc.clearDisplay(0);
}

int count = 0;
void loop() { 
  displayNumber(count);
  count++;
  delay(1000);
}
