/* Copyright c 2016 RobotsForFun.com

   This program will turn on the internal LED when the correct
   password is entered. The password is 123
   The keys entered are continuous and do not have to be in groups of threes.
*/

#include <Keypad.h>

const byte ROWS = 4; //four rows
const byte COLS = 3; //three columns
char keys[ROWS][COLS] = {
  {'1','2','3'},
  {'4','5','6'},
  {'7','8','9'},
  {'*','0','#'}
};
byte rowPins[ROWS] = {8, 7, 6, 5}; //connect to the column pinouts of the keypad
byte colPins[COLS] = {4, 3, 2}; //connect to the row pinouts of the keypad
Keypad keypad = Keypad( makeKeymap(keys), rowPins, colPins, ROWS, COLS );


int digit;
char key[3];
char password[3] = {'1', '2', '3'};

void setup(){
  Serial.begin(9600);
  Serial.println("Enter a 3-digit password (123) to turn on the LED");
  pinMode(13, OUTPUT);
  digit = 0;
}

  
void loop(){
  char c;
  c = keypad.getKey();
   
  if (c) {  // check for a key pressed
    if (c == password[digit]){  // does it match the password?
      Serial.print('*');  // show some action
      digit++;
    } else {
      digitalWrite(13, LOW);
      digit = 0;
    }
    if (digit == 3) {
      Serial.println("\nYou have entered the correct password");
      digitalWrite(13, HIGH);
      digit = 0;
    }
  }
}
