//////////////////////////////////////////////////////////
// NTP (Network Time Protocol) Date Time library
// Clock is automatically set using NTP
//
// Copyright (c) 2020 Enoch Hwang

#define statusLed 2     // for ESP8266-12

//////////////////////////////////////////////////////////////
//// NTP clock stuff
#include <DateTime_RobotsForFun.h>

//////////////////////////////////////////////////////////////
//// WiFi stuff
#define USE_DEFAULT_INDEXHTML  // define this to use the default indexHTML function
#include <WiFi_RobotsForFun.h>


void setup() {
  Serial.begin(115200);
  
  //// set clock time zone to PST
  setClock(PST);
  
  //// WiFi stuff
  char ssid[] = "your ssid";           // change this to your ssid
  char password[] = "your password";   // change this to your password
  setupWiFi(ssid, password);

  // wait for clock to sync with server
  waitForTimeValid();
}


void loop() {
  static time_t prevDisplay;
  if (time(nullptr) != prevDisplay) { //update the display only if time has changed
    prevDisplay = now();
    Serial.println(formattedTime());
  }
}
